@echo off
setlocal enabledelayedexpansion

:: =========================================
:: 1. CẤU HÌNH CƠ BẢN
:: =========================================
set "WAZUH_VERSION=4.14.1-1"
set "WAZUH_INSTALLER_URL=https://packages.wazuh.com/4.x/windows/wazuh-agent-%WAZUH_VERSION%.msi"
set "INSTALLER_NAME=wazuh-agent-%WAZUH_VERSION%.msi"
set "INSTALLER_PATH=%TEMP%\%INSTALLER_NAME%"
set "LOCAL_INSTALLER_PATH=%~dp0%INSTALLER_NAME%"
set "WAZUH_PATH=C:\Program Files (x86)\ossec-agent"

:: Kiểm tra quyền Administrator
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Vui long chay script voi quyen Administrator.
    pause
    exit /b
)

:: =========================================
:: 2. CHỌN CHẾ ĐỘ CÀI ĐẶT
:: =========================================
echo =======================================================
echo  Chon che do cai dat Wazuh Agent:
echo    [1] Online  - Tai tu Internet
echo    [2] Offline - Dung file .msi co san cung thu muc
echo =======================================================
set /p MODE=Nhap lua chon (1 hoac 2): 

if "%MODE%"=="2" (
    if not exist "%LOCAL_INSTALLER_PATH%" (
        echo [ERROR] Khong tim thay file %LOCAL_INSTALLER_PATH%
        echo Vui long dat file installer trong thu muc nay va chay lai.
        pause
        exit /b
    )
    echo Su dung file local: %LOCAL_INSTALLER_PATH%
    set "INSTALLER_PATH=%LOCAL_INSTALLER_PATH%"
) else (
    echo Su dung che do Online - tai ve tu Internet...
    if not exist "%INSTALLER_PATH%" (
        echo Downloading Wazuh Agent installer...
        powershell -Command "Invoke-WebRequest -UseBasicParsing -Uri '%WAZUH_INSTALLER_URL%' -OutFile '%INSTALLER_PATH%'"
    ) else (
        echo File installer da ton tai: %INSTALLER_PATH%
    )
)

if not exist "%INSTALLER_PATH%" (
    echo [ERROR] Khong tim thay file cai dat Wazuh Agent.
    pause
    exit /b
)

:: =========================================
:: 3. NHẬP DANH SÁCH IP (CLUSTER)
:: =========================================
echo =======================================================
echo Vi du nhap IP Cluster: 172.0.0.3 172.0.0.4 172.0.0.5
echo (Cach nhau bang dau cach hoac dau phay)
echo =======================================================
set /p INPUT_IPS=Nhap danh sach Wazuh Manager IP: 

set "CLEAN_IPS=%INPUT_IPS:,= %"
for /f "tokens=1" %%a in ("%CLEAN_IPS%") do set "PRIMARY_MANAGER=%%a"

if "%PRIMARY_MANAGER%"=="" (
    echo [ERROR] Ban chua nhap IP nao ca.
    pause
    exit /b
)

echo.
echo ---------------------------------------------
echo Managers List: %CLEAN_IPS%
echo Primary (Auth): %PRIMARY_MANAGER%
echo ---------------------------------------------
echo.

:: =========================================
:: 4. CÀI ĐẶT AGENT (Sử dụng IP đầu tiên để đăng ký)
:: =========================================
echo Installing Wazuh Agent...
msiexec.exe /i "%INSTALLER_PATH%" /qn WAZUH_MANAGER="%PRIMARY_MANAGER%" WAZUH_REGISTRATION_SERVER="%PRIMARY_MANAGER%" WAZUH_AGENT_NAME="%COMPUTERNAME%" WAZUH_AGENT_GROUP="Windows_Server"

timeout /t 5 /nobreak >nul
net stop wazuhsvc >nul 2>&1

:: =========================================
:: 5. CẤU HÌNH FAILOVER (SỬA OSSEC.CONF)
:: =========================================
echo Configuring Cluster Failover in ossec.conf...

powershell -Command ^
    "$path = '%WAZUH_PATH%\ossec.conf';" ^
    "$ips = '%CLEAN_IPS%'.Split(' ', [System.StringSplitOptions]::RemoveEmptyEntries);" ^
    "$xml = [xml](Get-Content $path);" ^
    "$client = $xml.ossec_config.client;" ^
    "$existingServers = $client.SelectNodes('server');" ^
    "foreach ($s in $existingServers) { $client.RemoveChild($s) | Out-Null };" ^
    "foreach ($ip in $ips) {" ^
        "$newServer = $xml.CreateElement('server');" ^
        "$addr = $xml.CreateElement('address'); $addr.InnerText = $ip;" ^
        "$port = $xml.CreateElement('port'); $port.InnerText = '1514';" ^
        "$proto = $xml.CreateElement('protocol'); $proto.InnerText = 'tcp';" ^
        "$newServer.AppendChild($addr); $newServer.AppendChild($port); $newServer.AppendChild($proto);" ^
        "$client.AppendChild($newServer);" ^
    "}" ^
    "$xml.Save($path);"

:: =========================================
:: 6. KHỞI ĐỘNG LẠI SERVICE
:: =========================================
echo Starting Wazuh Service...
net start wazuhsvc

:: =========================================
:: 7. HOÀN TẤT
:: =========================================
echo.
echo =========================================
echo Wazuh Agent installed and configured with Cluster!
echo.
echo Configured Nodes:
for %%i in (%CLEAN_IPS%) do (
    echo  - %%i
)
echo =========================================
pause
