@echo off
setlocal enabledelayedexpansion

:: =========================================
:: 1. CẤU HÌNH CƠ BẢN
:: =========================================
:: Lưu ý: Xóa khoảng trắng thừa trong phiên bản
set "WAZUH_VERSION=4.14.1-1"
set "WAZUH_INSTALLER_URL=https://packages.wazuh.com/4.x/windows/wazuh-agent-%WAZUH_VERSION%.msi"
set "INSTALLER_PATH=%TEMP%\wazuh-agent-%WAZUH_VERSION%.msi"
set "WAZUH_PATH=C:\Program Files (x86)\ossec-agent"

:: =========================================
:: 2. NHẬP DANH SÁCH IP (CLUSTER)
:: =========================================
echo =======================================================
echo Vi du nhap IP Cluster: 172.0.0.3 172.0.0.4 172.0.0.5
echo (Cach nhau bang dau cach hoac dau phay)
echo =======================================================
set /p INPUT_IPS=Nhap danh sach Wazuh Manager IP: 

:: Thay thế dấu phẩy thành dấu cách để xử lý
set "CLEAN_IPS=%INPUT_IPS:,= %"

:: Lấy IP đầu tiên để dùng cho quá trình cài đặt (Enrollment ban đầu)
for /f "tokens=1" %%a in ("%CLEAN_IPS%") do set "PRIMARY_MANAGER=%%a"

if "%PRIMARY_MANAGER%"=="" (
    echo [ERROR] Ban chua nhap IP nao ca.
    pause
    exit /b
)

echo.
echo ---------------------------------------------
echo Managers List: %CLEAN_IPS%
echo Primary (Auth): %PRIMARY_MANAGER%
echo ---------------------------------------------
echo.

:: =========================================
:: 3. TẢI BỘ CÀI ĐẶT
:: =========================================
if not exist "%INSTALLER_PATH%" (
    echo Downloading Wazuh Agent installer...
    powershell -Command "Invoke-WebRequest -Uri '%WAZUH_INSTALLER_URL%' -OutFile '%INSTALLER_PATH%'"
) else (
    echo Installer already exists at %INSTALLER_PATH%
)

:: =========================================
:: 4. CÀI ĐẶT AGENT (Sử dụng IP đầu tiên để đăng ký)
:: =========================================
echo Installing Wazuh Agent...
:: Cài đặt nhưng chưa start vội (để sửa config đã)
msiexec.exe /i "%INSTALLER_PATH%" /qn WAZUH_MANAGER="%PRIMARY_MANAGER%" WAZUH_REGISTRATION_SERVER="%PRIMARY_MANAGER%" WAZUH_AGENT_NAME="%COMPUTERNAME%" WAZUH_AGENT_GROUP="Windows_Server"

:: Đợi một chút để file được giải nén
timeout /t 5 /nobreak >nul

:: Dừng service để sửa file config an toàn
net stop wazuhsvc >nul 2>&1

:: =========================================
:: 5. CẤU HÌNH FAILOVER (SỬA OSSEC.CONF)
:: =========================================
echo Configuring Cluster Failover in ossec.conf...

:: Sử dụng PowerShell để parse XML và chèn nhiều block <server>
:: Logic: Đọc file -> Tìm thẻ client -> Xóa thẻ server cũ -> Thêm thẻ server mới cho từng IP
powershell -Command ^
    "$path = '%WAZUH_PATH%\ossec.conf';" ^
    "$ips = '%CLEAN_IPS%'.Split(' ', [System.StringSplitOptions]::RemoveEmptyEntries);" ^
    "$xml = [xml](Get-Content $path);" ^
    "$client = $xml.ossec_config.client;" ^
    "$existingServers = $client.SelectNodes('server');" ^
    "foreach ($s in $existingServers) { $client.RemoveChild($s) | Out-Null };" ^
    "foreach ($ip in $ips) {" ^
        "$newServer = $xml.CreateElement('server');" ^
        "$addr = $xml.CreateElement('address'); $addr.InnerText = $ip;" ^
        "$port = $xml.CreateElement('port'); $port.InnerText = '1514';" ^
        "$proto = $xml.CreateElement('protocol'); $proto.InnerText = 'tcp';" ^
        "$newServer.AppendChild($addr); $newServer.AppendChild($port); $newServer.AppendChild($proto);" ^
        "$client.AppendChild($newServer);" ^
    "}" ^
    "$xml.Save($path);"

:: =========================================
:: 6. KHỞI ĐỘNG LẠI SERVICE
:: =========================================
echo Starting Wazuh Service...
net start wazuhsvc

:: =========================================
:: 7. HOÀN TẤT
:: =========================================
echo.
echo =========================================
echo Wazuh Agent installed and configured with Cluster!
echo.
echo Configured Nodes:
for %%i in (%CLEAN_IPS%) do (
    echo  - %%i
)
echo =========================================
pause