#!/bin/bash

WAZUH_MANAGER="10.120.100.9"
WAZUH_GROUP="linux_agent"

WAZUH_AGENT_NAME=$(hostname)
AGENT_IP=$(hostname -I | awk '{print $1}')

echo "Installing Wazuh Agent on RHEL 7..."
echo "---------------------------------------------"
echo "Manager: $WAZUH_MANAGER"
echo "Group:   $WAZUH_GROUP"
echo "Name:    $WAZUH_AGENT_NAME"
echo "IP:      $AGENT_IP"
echo "---------------------------------------------"

# Check for root privileges
if [[ $EUID -ne 0 ]]; then
   echo "Please run this script with root privileges (sudo)."
   exit 1
fi

# Add Wazuh repository
cat > /etc/yum.repos.d/wazuh.repo << EOF
[wazuh_repo]
name=Wazuh Repository
baseurl=https://packages.wazuh.com/4.x/yum/
gpgcheck=1
gpgkey=https://packages.wazuh.com/key/GPG-KEY-WAZUH
enabled=1
EOF

# Install Wazuh Agent
yum install wazuh-agent -y

# Agent enrollment
echo "Registering the agent with the Wazuh Manager..."
/var/ossec/bin/agent-auth -m $WAZUH_MANAGER -A $WAZUH_AGENT_NAME -G $WAZUH_GROUP -I $AGENT_IP

# Update manager IP in configuration
sed -i "s|<address>.*</address>|<address>$WAZUH_MANAGER</address>|g" /var/ossec/etc/ossec.conf

# Enable and start agent service
systemctl enable wazuh-agent
systemctl restart wazuh-agent

echo "---------------------------------------------"
echo "Wazuh Agent has been successfully installed and connected to Manager $WAZUH_MANAGER!"
echo "Agent Name: $WAZUH_AGENT_NAME"
echo "Agent IP:   $AGENT_IP"
echo "---------------------------------------------"
