@echo off
setlocal enabledelayedexpansion

:: =========================================
:: Wazuh Agent Installer Configuration
:: =========================================
set "WAZUH_VERSION=4.13.1-1"
set "WAZUH_INSTALLER_URL=https://packages.wazuh.com/4.x/windows/wazuh-agent-%WAZUH_VERSION%.msi"
set "INSTALLER_PATH=%TEMP%\wazuh-agent-%WAZUH_VERSION%.msi"

:: =========================================
:: Ask user for Wazuh Manager IP
:: =========================================
echo =========================================
set /p WAZUH_MANAGER=Enter Wazuh Manager IP: 
echo =========================================

:: =========================================
:: Download Wazuh Agent if not already downloaded
:: =========================================
if not exist "%INSTALLER_PATH%" (
    echo Downloading Wazuh Agent installer...
    powershell -Command "Invoke-WebRequest -Uri '%WAZUH_INSTALLER_URL%' -OutFile '%INSTALLER_PATH%'"
) else (
    echo Installer already exists at %INSTALLER_PATH%
)

:: =========================================
:: Install Wazuh Agent
:: =========================================
echo Installing Wazuh Agent...
msiexec.exe /i "%INSTALLER_PATH%" /qn WAZUH_MANAGER="%WAZUH_MANAGER%" WAZUH_REGISTRATION_SERVER="%WAZUH_MANAGER%" WAZUH_AGENT_NAME="%COMPUTERNAME%" WAZUH_AGENT_GROUP="Windows_Server"

:: =========================================
:: Restart Wazuh Service
:: =========================================
echo Restarting Wazuh Service...
net stop wazuhsvc >nul 2>&1
net start wazuhsvc

:: =========================================
:: Display completion message
:: =========================================
echo.
echo =========================================
echo Wazuh Agent has been installed and configured!
echo Manager IP: %WAZUH_MANAGER%
echo =========================================
pause
